DROP PROCEDURE ALTERA_CODIGO_EMPRESA;
DROP PROCEDURE ALTERA_CODIGO_FUNCIONARIO;
DROP PROCEDURE EXCLUIR_DADOS_DIGITADO;
DROP PROCEDURE EXCLUIR_EMPRESA_MOVIMENTO;
DROP PROCEDURE EXCLUIR_DADOS_CADASTROS;
DROP PROCEDURE EXCLUIR_EMPRESA_CADASTRO;
DROP PROCEDURE EXCLUIR_FUNCIONARIO_CADASTRO;
DROP TABLE PHMGPS;
DROP TABLE PHMGPS2;
DROP TABLE PHMSFP;


CREATE TABLE "PHTDPA" 
(
  "CAMPID"	 VARCHAR(10) NOT NULL,
  "CAMPDE"	 VARCHAR(10) NOT NULL,
  "CAMPPA"	 VARCHAR(10),
  "OBSERV"	 VARCHAR(30),
 PRIMARY KEY ("CAMPID", "CAMPDE")
);

CREATE TABLE "PHCGPS" 
(
  "CODEMP"	 VARCHAR(4) NOT NULL,
  "CODCAD"	 VARCHAR(10) NOT NULL,
  "ANOMES"	 VARCHAR(8) NOT NULL,
  "CODFOL"	 VARCHAR(4) NOT NULL,
  "CODREC"	 VARCHAR(4),
  "INSBAS"	 VARCHAR(15),
  "INSALQ"	 VARCHAR(7),
  "INSVAL"	 VARCHAR(15),
  "CONBAS"	 VARCHAR(15),
  "CONALQ"	 VARCHAR(7),
  "CONVAL"	 VARCHAR(15),
  "TOTGPS"	 VARCHAR(15),
  "EMITIU"	 VARCHAR(2),
  "DATEMI"	 VARCHAR(10),
  "NOMUSU"	 VARCHAR(10),
 PRIMARY KEY ("CODEMP", "CODCAD", "ANOMES", "CODFOL")
);

DROP TABLE PHMGPS;
DROP TABLE PHMGPS2;
DROP TABLE PHMSFP;

CREATE TABLE "PHMGPS" 
(
  "CODEMP"	 VARCHAR(4) NOT NULL,
  "CODNIV"	 VARCHAR(2) NOT NULL,
  "ANOMES"	 VARCHAR(8) NOT NULL,
  "CODFOL"	 VARCHAR(2) NOT NULL,
  "CODTOM"	 VARCHAR(4) NOT NULL,
  "GPSFPA"	 VARCHAR(4),
  "GPSTER"	 VARCHAR(4),
  "GPSPGT"	 VARCHAR(4),
  "GPSACI"	 VARCHAR(4),
  "FILANT"	 VARCHAR(6),
  "REMFUN"	 VARCHAR(15),
  "REMPRO"	 VARCHAR(15),
  "REMAUT"	 VARCHAR(15),
  "INSSEG"	 VARCHAR(15),
  "INSPRO"	 VARCHAR(15),
  "INSAUT"	 VARCHAR(15),
  "PEREFU"	 VARCHAR(5),
  "INSEFU"	 VARCHAR(15),
  "PEREPL"	 VARCHAR(5),
  "INSEPL"	 VARCHAR(15),
  "PEREAU"	 VARCHAR(5),
  "INSEAU"	 VARCHAR(15),
  "PEREAC"	 VARCHAR(5),
  "INSEAC"	 VARCHAR(15),
  "SALFAM"	 VARCHAR(15),
  "SALMAT"	 VARCHAR(15),
  "DECMAT"	 VARCHAR(15),
  "PERTER"	 VARCHAR(5),
  "TERCEI"	 VARCHAR(15),
  "CMPVAL"	 VARCHAR(15),
  "CMPINI"	 VARCHAR(8),
  "CMPFIN"	 VARCHAR(8),
  "COOTRA"	 VARCHAR(15),
  "RESTIT"	 VARCHAR(15),
  "TOTGPS"	 VARCHAR(15),
  "EMITIU"	 VARCHAR(2),
  "DATEMI"	 VARCHAR(10),
  "NOMUSU"	 VARCHAR(10),
 PRIMARY KEY ("CODEMP", "CODNIV", "ANOMES", "CODFOL", "CODTOM")
);

CREATE TABLE "PHMGPS2" 
(
  "CODEMP"	 VARCHAR(4) NOT NULL,
  "CODNIV"	 VARCHAR(2) NOT NULL,
  "ANOMES"	 VARCHAR(8) NOT NULL,
  "CODFOL"	 VARCHAR(2) NOT NULL,
  "CODTOM"	 VARCHAR(4) NOT NULL,
  "NOTAS1"	 VARCHAR(80),
  "NOTAS2"	 VARCHAR(80),
  "NOTAS3"	 VARCHAR(80),
  "NOTAS4"	 VARCHAR(80),
  "TOTNFS"	 VARCHAR(15),
  "RETNFS"	 VARCHAR(15),
 PRIMARY KEY ("CODEMP", "CODNIV", "ANOMES", "CODFOL", "CODTOM")
);

CREATE TABLE "PHMSFP" 
(
  "CODEMP"	 VARCHAR(4) NOT NULL,
  "CODNIV"	 VARCHAR(2) NOT NULL,
  "ANOMES"	 VARCHAR(8) NOT NULL,
  "CODFOL"	 VARCHAR(2) NOT NULL,
  "CODTOM"	 VARCHAR(4) NOT NULL,
  "SFPREC"	 VARCHAR(4),
  "RECEVT"	 VARCHAR(15),
  "RECORI"	 VARCHAR(1),
  "PRCFIS"	 VARCHAR(15),
  "PRVFIS"	 VARCHAR(15),
  "PRCJUR"	 VARCHAR(15),
  "PRVJUR"	 VARCHAR(15),
  "PRCNUM"	 VARCHAR(20),
  "PRCANO"	 VARCHAR(4),
  "PRCJCJ"	 VARCHAR(10),
  "PRCINI"	 VARCHAR(8),
  "PRCFIM"	 VARCHAR(8),
  "REMSAL"	 VARCHAR(15),
  "FGTSAL"	 VARCHAR(15),
  "REM13S"	 VARCHAR(15),
  "FGT13S"	 VARCHAR(15),
  "CONSOC"	 VARCHAR(15),
  "LIQSFP"	 VARCHAR(15),
 PRIMARY KEY ("CODEMP", "CODNIV", "ANOMES", "CODFOL", "CODTOM")
);

CREATE PROCEDURE "ALTERA_CODIGO_EMPRESA" 
(
  "XCODEMP" VARCHAR(4),
  "XEMPATU" VARCHAR(4)
)
AS
BEGIN EXIT; END ^


ALTER PROCEDURE "ALTERA_CODIGO_EMPRESA" 
(
  "XCODEMP" VARCHAR(4),
  "XEMPATU" VARCHAR(4)
)
AS
begin
UPDATE PHCAFA  SET PHCAFA.CODEMP = :XEMPATU  WHERE PHCAFA.CODEMP = :XCODEMP;
UPDATE PHCAFA2  SET PHCAFA2.CODEMP = :XEMPATU  WHERE PHCAFA2.CODEMP = :XCODEMP;
UPDATE PHCBEN  SET PHCBEN.CODEMP = :XEMPATU  WHERE PHCBEN.CODEMP = :XCODEMP;
UPDATE PHCCAD  SET PHCCAD.CODEMP = :XEMPATU  WHERE PHCCAD.CODEMP = :XCODEMP;
UPDATE PHCCAD2 SET PHCCAD2.CODEMP = :XEMPATU  WHERE PHCCAD2.CODEMP = :XCODEMP;
UPDATE PHCFUN  SET PHCFUN.CODEMP = :XEMPATU  WHERE PHCFUN.CODEMP = :XCODEMP;
UPDATE PHCSAL  SET PHCSAL.CODEMP = :XEMPATU  WHERE PHCSAL.CODEMP = :XCODEMP;
UPDATE PHCLOT  SET PHCLOT.CODEMP = :XEMPATU  WHERE PHCLOT.CODEMP = :XCODEMP;
UPDATE PHCCAR  SET PHCCAR.CODEMP = :XEMPATU  WHERE PHCCAR.CODEMP = :XCODEMP;
UPDATE PHCCNJ  SET PHCCNJ.CODEMP = :XEMPATU  WHERE PHCCNJ.CODEMP = :XCODEMP;
UPDATE PHCDEP  SET PHCDEP.CODEMP = :XEMPATU  WHERE PHCDEP.CODEMP = :XCODEMP;
UPDATE PHCDOC  SET PHCDOC.CODEMP = :XEMPATU  WHERE PHCDOC.CODEMP = :XCODEMP;
UPDATE PHCEMP  SET PHCEMP.CODEMP = :XEMPATU  WHERE PHCEMP.CODEMP = :XCODEMP;
UPDATE PHCEND  SET PHCEND.CODEMP = :XEMPATU  WHERE PHCEND.CODEMP = :XCODEMP;
UPDATE PHCEST  SET PHCEST.CODEMP = :XEMPATU  WHERE PHCEST.CODEMP = :XCODEMP;
UPDATE PHCEXA  SET PHCEXA.CODEMP = :XEMPATU  WHERE PHCEXA.CODEMP = :XCODEMP;
UPDATE PHCFER  SET PHCFER.CODEMP = :XEMPATU  WHERE PHCFER.CODEMP = :XCODEMP;
UPDATE PHCFIX  SET PHCFIX.CODEMP = :XEMPATU  WHERE PHCFIX.CODEMP = :XCODEMP;
UPDATE PHCNAT  SET PHCNAT.CODEMP = :XEMPATU  WHERE PHCNAT.CODEMP = :XCODEMP;
UPDATE PHCPIS  SET PHCPIS.CODEMP = :XEMPATU  WHERE PHCPIS.CODEMP = :XCODEMP;
UPDATE PHCPRE  SET PHCPRE.CODEMP = :XEMPATU  WHERE PHCPRE.CODEMP = :XCODEMP;
UPDATE PHCPRO  SET PHCPRO.CODEMP = :XEMPATU  WHERE PHCPRO.CODEMP = :XCODEMP;
UPDATE PHCRES  SET PHCRES.CODEMP = :XEMPATU  WHERE PHCRES.CODEMP = :XCODEMP;
UPDATE PHCSIN  SET PHCSIN.CODEMP = :XEMPATU  WHERE PHCSIN.CODEMP = :XCODEMP;
UPDATE PHCGPS  SET PHCGPS.CODEMP = :XEMPATU  WHERE PHCGPS.CODEMP = :XCODEMP;
UPDATE PHCVIN  SET PHCVIN.CODEMP = :XEMPATU  WHERE PHCVIN.CODEMP = :XCODEMP;
UPDATE PHMBSS  SET PHMBSS.CODEMP = :XEMPATU  WHERE PHMBSS.CODEMP = :XCODEMP;
UPDATE PHMMFR  SET PHMMFR.CODEMP = :XEMPATU  WHERE PHMMFR.CODEMP = :XCODEMP;
UPDATE PHMFIN  SET PHMFIN.CODEMP = :XEMPATU  WHERE PHMFIN.CODEMP = :XCODEMP;
UPDATE PHMPRV  SET PHMPRV.CODEMP = :XEMPATU  WHERE PHMPRV.CODEMP = :XCODEMP;
UPDATE PHMGPS  SET PHMGPS.CODEMP = :XEMPATU  WHERE PHMGPS.CODEMP = :XCODEMP;
UPDATE PHMGPS2 SET PHMGPS2.CODEMP = :XEMPATU  WHERE PHMGPS2.CODEMP = :XCODEMP;
UPDATE PHMSFP  SET PHMSFP.CODEMP = :XEMPATU  WHERE PHMSFP.CODEMP = :XCODEMP;
UPDATE PHMMST  SET PHMMST.CODEMP = :XEMPATU  WHERE PHMMST.CODEMP = :XCODEMP;
UPDATE PHMCST  SET PHMCST.CODEMP = :XEMPATU  WHERE PHMCST.CODEMP = :XCODEMP;
UPDATE PHMDIG  SET PHMDIG.CODEMP = :XEMPATU  WHERE PHMDIG.CODEMP = :XCODEMP;
UPDATE PHMFXE  SET PHMFXE.CODEMP = :XEMPATU  WHERE PHMFXE.CODEMP = :XCODEMP;
UPDATE PHTEMP3 SET PHTEMP3.CODEMP = :XEMPATU WHERE PHTEMP3.CODEMP = :XCODEMP;
UPDATE PHTEMP2 SET PHTEMP2.CODEMP = :XEMPATU WHERE PHTEMP2.CODEMP = :XCODEMP;
UPDATE PHTEMP  SET PHTEMP.CODEMP  = :XEMPATU WHERE PHTEMP.CODEMP = :XCODEMP;
end
 ^

SET TERM ; ^
COMMIT WORK;
SET AUTODDL ON;


COMMIT WORK;
SET AUTODDL OFF;
SET TERM ^ ;

CREATE PROCEDURE "ALTERA_CODIGO_FUNCIONARIO" 
(
  "XCODEMP" VARCHAR(4),
  "XCODCAD" VARCHAR(10),
  "XEMPATU" VARCHAR(4),
  "XCADATU" VARCHAR(10)
)
AS
BEGIN EXIT; END ^


ALTER PROCEDURE "ALTERA_CODIGO_FUNCIONARIO" 
(
  "XCODEMP" VARCHAR(4),
  "XCODCAD" VARCHAR(10),
  "XEMPATU" VARCHAR(4),
  "XCADATU" VARCHAR(10)
)
AS
begin
UPDATE PHCAFA  SET PHCAFA.CODEMP  = :XEMPATU, PHCAFA.CODCAD  = :XCADATU  WHERE (PHCAFA.CODEMP  = :XCODEMP AND PHCAFA.CODCAD  = :XCODCAD);
UPDATE PHCAFA2  SET PHCAFA2.CODEMP  = :XEMPATU, PHCAFA2.CODCAD  = :XCADATU  WHERE (PHCAFA2.CODEMP  = :XCODEMP AND PHCAFA2.CODCAD  = :XCODCAD);
UPDATE PHCBEN  SET PHCBEN.CODEMP  = :XEMPATU, PHCBEN.CODCAD  = :XCADATU  WHERE (PHCBEN.CODEMP  = :XCODEMP AND PHCBEN.CODCAD  = :XCODCAD);
UPDATE PHCCAD  SET PHCCAD.CODEMP  = :XEMPATU, PHCCAD.CODCAD  = :XCADATU  WHERE (PHCCAD.CODEMP  = :XCODEMP AND PHCCAD.CODCAD  = :XCODCAD);
UPDATE PHCCAD2 SET PHCCAD2.CODEMP = :XEMPATU, PHCCAD2.CODCAD = :XCADATU  WHERE (PHCCAD2.CODEMP = :XCODEMP AND PHCCAD2.CODCAD = :XCODCAD);
UPDATE PHCFUN  SET PHCFUN.CODEMP  = :XEMPATU, PHCFUN.CODCAD  = :XCADATU  WHERE (PHCFUN.CODEMP  = :XCODEMP AND PHCFUN.CODCAD  = :XCODCAD);
UPDATE PHCSAL  SET PHCSAL.CODEMP  = :XEMPATU, PHCSAL.CODCAD  = :XCADATU  WHERE (PHCSAL.CODEMP  = :XCODEMP AND PHCSAL.CODCAD  = :XCODCAD);
UPDATE PHCLOT  SET PHCLOT.CODEMP  = :XEMPATU, PHCLOT.CODCAD  = :XCADATU  WHERE (PHCLOT.CODEMP  = :XCODEMP AND PHCLOT.CODCAD  = :XCODCAD);
UPDATE PHCCAR  SET PHCCAR.CODEMP  = :XEMPATU, PHCCAR.CODCAD  = :XCADATU  WHERE (PHCCAR.CODEMP  = :XCODEMP AND PHCCAR.CODCAD  = :XCODCAD);
UPDATE PHCCNJ  SET PHCCNJ.CODEMP  = :XEMPATU, PHCCNJ.CODCAD  = :XCADATU  WHERE (PHCCNJ.CODEMP  = :XCODEMP AND PHCCNJ.CODCAD  = :XCODCAD);
UPDATE PHCDEP  SET PHCDEP.CODEMP  = :XEMPATU, PHCDEP.CODCAD  = :XCADATU  WHERE (PHCDEP.CODEMP  = :XCODEMP AND PHCDEP.CODCAD  = :XCODCAD);
UPDATE PHCDOC  SET PHCDOC.CODEMP  = :XEMPATU, PHCDOC.CODCAD  = :XCADATU  WHERE (PHCDOC.CODEMP  = :XCODEMP AND PHCDOC.CODCAD  = :XCODCAD);
UPDATE PHCEMP  SET PHCEMP.CODEMP  = :XEMPATU, PHCEMP.CODCAD  = :XCADATU  WHERE (PHCEMP.CODEMP  = :XCODEMP AND PHCEMP.CODCAD  = :XCODCAD);
UPDATE PHCEND  SET PHCEND.CODEMP  = :XEMPATU, PHCEND.CODCAD  = :XCADATU  WHERE (PHCEND.CODEMP  = :XCODEMP AND PHCEND.CODCAD  = :XCODCAD);
UPDATE PHCEST  SET PHCEST.CODEMP  = :XEMPATU, PHCEST.CODCAD  = :XCADATU  WHERE (PHCEST.CODEMP  = :XCODEMP AND PHCEST.CODCAD  = :XCODCAD);
UPDATE PHCEXA  SET PHCEXA.CODEMP  = :XEMPATU, PHCEXA.CODCAD  = :XCADATU  WHERE (PHCEXA.CODEMP  = :XCODEMP AND PHCEXA.CODCAD  = :XCODCAD);
UPDATE PHCFER  SET PHCFER.CODEMP  = :XEMPATU, PHCFER.CODCAD  = :XCADATU  WHERE (PHCFER.CODEMP  = :XCODEMP AND PHCFER.CODCAD  = :XCODCAD);
UPDATE PHCFIX  SET PHCFIX.CODEMP  = :XEMPATU, PHCFIX.CODCAD  = :XCADATU  WHERE (PHCFIX.CODEMP  = :XCODEMP AND PHCFIX.CODCAD  = :XCODCAD);
UPDATE PHCNAT  SET PHCNAT.CODEMP  = :XEMPATU, PHCNAT.CODCAD  = :XCADATU  WHERE (PHCNAT.CODEMP  = :XCODEMP AND PHCNAT.CODCAD  = :XCODCAD);
UPDATE PHCPIS  SET PHCPIS.CODEMP  = :XEMPATU, PHCPIS.CODCAD  = :XCADATU  WHERE (PHCPIS.CODEMP  = :XCODEMP AND PHCPIS.CODCAD  = :XCODCAD);
UPDATE PHCPRE  SET PHCPRE.CODEMP  = :XEMPATU, PHCPRE.CODCAD  = :XCADATU  WHERE (PHCPRE.CODEMP  = :XCODEMP AND PHCPRE.CODCAD  = :XCODCAD);
UPDATE PHCPRO  SET PHCPRO.CODEMP  = :XEMPATU, PHCPRO.CODCAD  = :XCADATU  WHERE (PHCPRO.CODEMP  = :XCODEMP AND PHCPRO.CODCAD  = :XCODCAD);
UPDATE PHCRES  SET PHCRES.CODEMP  = :XEMPATU, PHCRES.CODCAD  = :XCADATU  WHERE (PHCRES.CODEMP  = :XCODEMP AND PHCRES.CODCAD  = :XCODCAD);
UPDATE PHCSIN  SET PHCSIN.CODEMP  = :XEMPATU, PHCSIN.CODCAD  = :XCADATU  WHERE (PHCSIN.CODEMP  = :XCODEMP AND PHCSIN.CODCAD  = :XCODCAD);
UPDATE PHCGPS  SET PHCGPS.CODEMP  = :XEMPATU, PHCGPS.CODCAD  = :XCADATU  WHERE (PHCGPS.CODEMP  = :XCODEMP AND PHCGPS.CODCAD  = :XCODCAD);
UPDATE PHCVIN  SET PHCVIN.CODEMP  = :XEMPATU, PHCVIN.CODCAD  = :XCADATU  WHERE (PHCVIN.CODEMP  = :XCODEMP AND PHCVIN.CODCAD  = :XCODCAD);
UPDATE PHMBSS  SET PHMBSS.CODEMP  = :XEMPATU, PHMBSS.CODCAD  = :XCADATU  WHERE (PHMBSS.CODEMP  = :XCODEMP AND PHMBSS.CODCAD  = :XCODCAD);
UPDATE PHMPRV  SET PHMPRV.CODEMP  = :XEMPATU, PHMPRV.CODCAD  = :XCADATU  WHERE (PHMPRV.CODEMP  = :XCODEMP AND PHMPRV.CODCAD  = :XCODCAD);
UPDATE PHMCST  SET PHMCST.CODEMP  = :XEMPATU, PHMCST.CODCAD  = :XCADATU  WHERE (PHMCST.CODEMP  = :XCODEMP AND PHMCST.CODCAD  = :XCODCAD);
UPDATE PHMMFR  SET PHMMFR.CODEMP  = :XEMPATU, PHMMFR.CODCAD  = :XCADATU  WHERE (PHMMFR.CODEMP  = :XCODEMP AND PHMMFR.CODCAD  = :XCODCAD);
UPDATE PHMFIN  SET PHMFIN.CODEMP  = :XEMPATU, PHMFIN.CODCAD  = :XCADATU  WHERE (PHMFIN.CODEMP  = :XCODEMP AND PHMFIN.CODCAD  = :XCODCAD);
end
 ^

SET TERM ; ^
COMMIT WORK;
SET AUTODDL ON;


COMMIT WORK;
SET AUTODDL OFF;
SET TERM ^ ;

CREATE PROCEDURE "EXCLUIR_DADOS_DIGITADO" 
AS
BEGIN EXIT; END ^


ALTER PROCEDURE "EXCLUIR_DADOS_DIGITADO" 
AS
begin
DELETE FROM PHMMST;
DELETE FROM PHMCST;
DELETE FROM PHMDIG;
DELETE FROM PHMGPS;
DELETE FROM PHMGPS2;
DELETE FROM PHMSFP;
end
 ^

SET TERM ; ^
COMMIT WORK;
SET AUTODDL ON;

CREATE PROCEDURE "EXCLUIR_EMPRESA_MOVIMENTO" 
(
  "XCODEMP" VARCHAR(4)
)
AS
BEGIN EXIT; END ^

ALTER PROCEDURE "EXCLUIR_EMPRESA_MOVIMENTO" 
(
  "XCODEMP" VARCHAR(4)
)
AS
begin
DELETE FROM PHMBSS  WHERE PHMBSS.CODEMP = :XCODEMP;
DELETE FROM PHMPRV  WHERE PHMPRV.CODEMP = :XCODEMP;
DELETE FROM PHMMFR  WHERE PHMMFR.CODEMP = :XCODEMP;
DELETE FROM PHMFIN  WHERE PHMFIN.CODEMP = :XCODEMP;
DELETE FROM PHMGPS  WHERE PHMGPS.CODEMP = :XCODEMP;
DELETE FROM PHMGPS2 WHERE PHMGPS2.CODEMP = :XCODEMP;
DELETE FROM PHMSFP  WHERE PHMSFP.CODEMP = :XCODEMP;
end
 ^

SET TERM ; ^
COMMIT WORK;
SET AUTODDL ON;



COMMIT WORK;
SET AUTODDL OFF;
SET TERM ^ ;

CREATE PROCEDURE "EXCLUIR_DADOS_CADASTROS" 
AS
BEGIN EXIT; END ^


ALTER PROCEDURE "EXCLUIR_DADOS_CADASTROS" 
AS
begin
DELETE FROM PHCAFA;
DELETE FROM PHCAFA2;
DELETE FROM PHCBEN;
DELETE FROM PHCCAD;
DELETE FROM PHCCAD2;
DELETE FROM PHCFUN;
DELETE FROM PHCSAL;
DELETE FROM PHCLOT;
DELETE FROM PHCCAR;
DELETE FROM PHCCNJ;
DELETE FROM PHCDEP;
DELETE FROM PHCDOC;
DELETE FROM PHCEMP;
DELETE FROM PHCEND;
DELETE FROM PHCEST;
DELETE FROM PHCEXA;
DELETE FROM PHCFER;
DELETE FROM PHCFIX;
DELETE FROM PHCNAT;
DELETE FROM PHCPIS;
DELETE FROM PHCPRE;
DELETE FROM PHCPRO;
DELETE FROM PHCRES;
DELETE FROM PHCSIN;
DELETE FROM PHCGPS;
DELETE FROM PHCVIN;
end
 ^

SET TERM ; ^
COMMIT WORK;
SET AUTODDL ON;



COMMIT WORK;
SET AUTODDL OFF;
SET TERM ^ ;


CREATE PROCEDURE "EXCLUIR_EMPRESA_CADASTRO" 
(
  "XCODEMP" VARCHAR(4)
)
AS
BEGIN EXIT; END ^


ALTER PROCEDURE "EXCLUIR_EMPRESA_CADASTRO" 
(
  "XCODEMP" VARCHAR(4)
)
AS
begin
DELETE FROM PHCAFA WHERE PHCAFA.CODEMP = :XCODEMP;
DELETE FROM PHCAFA2 WHERE PHCAFA2.CODEMP = :XCODEMP;
DELETE FROM PHCBEN WHERE PHCBEN.CODEMP = :XCODEMP;
DELETE FROM PHCCAD WHERE PHCCAD.CODEMP = :XCODEMP;
DELETE FROM PHCCAD2 WHERE PHCCAD2.CODEMP = :XCODEMP;
DELETE FROM PHCFUN WHERE PHCFUN.CODEMP = :XCODEMP;
DELETE FROM PHCSAL WHERE PHCSAL.CODEMP = :XCODEMP;
DELETE FROM PHCLOT WHERE PHCLOT.CODEMP = :XCODEMP;
DELETE FROM PHCCAR WHERE PHCCAR.CODEMP = :XCODEMP;
DELETE FROM PHCCNJ WHERE PHCCNJ.CODEMP = :XCODEMP;
DELETE FROM PHCDEP WHERE PHCDEP.CODEMP = :XCODEMP;
DELETE FROM PHCDOC WHERE PHCDOC.CODEMP = :XCODEMP;
DELETE FROM PHCEMP WHERE PHCEMP.CODEMP = :XCODEMP;
DELETE FROM PHCEND WHERE PHCEND.CODEMP = :XCODEMP;
DELETE FROM PHCEST WHERE PHCEST.CODEMP = :XCODEMP;
DELETE FROM PHCEXA WHERE PHCEXA.CODEMP = :XCODEMP;
DELETE FROM PHCFER WHERE PHCFER.CODEMP = :XCODEMP;
DELETE FROM PHCFIX WHERE PHCFIX.CODEMP = :XCODEMP;
DELETE FROM PHCNAT WHERE PHCNAT.CODEMP = :XCODEMP;
DELETE FROM PHCPIS WHERE PHCPIS.CODEMP = :XCODEMP;
DELETE FROM PHCPRE WHERE PHCPRE.CODEMP = :XCODEMP;
DELETE FROM PHCPRO WHERE PHCPRO.CODEMP = :XCODEMP;
DELETE FROM PHCRES WHERE PHCRES.CODEMP = :XCODEMP;
DELETE FROM PHCSIN WHERE PHCSIN.CODEMP = :XCODEMP;
DELETE FROM PHCGPS WHERE PHCGPS.CODEMP = :XCODEMP;
DELETE FROM PHCVIN WHERE PHCVIN.CODEMP = :XCODEMP;
end
 ^

SET TERM ; ^
COMMIT WORK;
SET AUTODDL ON;


COMMIT WORK;
SET AUTODDL OFF;
SET TERM ^ ;


CREATE PROCEDURE "EXCLUIR_FUNCIONARIO_CADASTRO" 
(
  "XCODEMP" VARCHAR(4),
  "XCODCAD" VARCHAR(7)
)
AS
BEGIN EXIT; END ^


ALTER PROCEDURE "EXCLUIR_FUNCIONARIO_CADASTRO" 
(
  "XCODEMP" VARCHAR(4),
  "XCODCAD" VARCHAR(7)
)
AS
begin
DELETE FROM PHCAFA  WHERE PHCAFA.CODEMP = :XCODEMP AND PHCAFA.CODCAD = :XCODCAD;
DELETE FROM PHCAFA2 WHERE PHCAFA2.CODEMP = :XCODEMP AND PHCAFA2.CODCAD = :XCODCAD;
DELETE FROM PHCBEN  WHERE PHCBEN.CODEMP = :XCODEMP AND PHCBEN.CODCAD = :XCODCAD;
DELETE FROM PHCCAD  WHERE PHCCAD.CODEMP = :XCODEMP AND PHCCAD.CODCAD = :XCODCAD;
DELETE FROM PHCCAD2 WHERE PHCCAD2.CODEMP = :XCODEMP AND PHCCAD2.CODCAD = :XCODCAD;
DELETE FROM PHCCAR  WHERE PHCCAR.CODEMP = :XCODEMP AND PHCCAR.CODCAD = :XCODCAD;
DELETE FROM PHCCNJ  WHERE PHCCNJ.CODEMP = :XCODEMP AND PHCCNJ.CODCAD = :XCODCAD;
DELETE FROM PHCDEP  WHERE PHCDEP.CODEMP = :XCODEMP AND PHCDEP.CODCAD = :XCODCAD;
DELETE FROM PHCDOC  WHERE PHCDOC.CODEMP = :XCODEMP AND PHCDOC.CODCAD = :XCODCAD;
DELETE FROM PHCDSP  WHERE PHCDSP.CODEMP = :XCODEMP AND PHCDSP.CODCAD = :XCODCAD;
DELETE FROM PHCEMP  WHERE PHCEMP.CODEMP = :XCODEMP AND PHCEMP.CODCAD = :XCODCAD;
DELETE FROM PHCEND  WHERE PHCEND.CODEMP = :XCODEMP AND PHCEND.CODCAD = :XCODCAD;
DELETE FROM PHCEST  WHERE PHCEST.CODEMP = :XCODEMP AND PHCEST.CODCAD = :XCODCAD;
DELETE FROM PHCEXA  WHERE PHCEXA.CODEMP = :XCODEMP AND PHCEXA.CODCAD = :XCODCAD;
DELETE FROM PHCEXP  WHERE PHCEXP.CODEMP = :XCODEMP AND PHCEXP.CODCAD = :XCODCAD;
DELETE FROM PHCFER  WHERE PHCFER.CODEMP = :XCODEMP AND PHCFER.CODCAD = :XCODCAD;
DELETE FROM PHCFIX  WHERE PHCFIX.CODEMP = :XCODEMP AND PHCFIX.CODCAD = :XCODCAD;
DELETE FROM PHCFUN  WHERE PHCFUN.CODEMP = :XCODEMP AND PHCFUN.CODCAD = :XCODCAD;
DELETE FROM PHCSAL  WHERE PHCSAL.CODEMP = :XCODEMP AND PHCSAL.CODCAD = :XCODCAD;
DELETE FROM PHCLOT  WHERE PHCLOT.CODEMP = :XCODEMP AND PHCLOT.CODCAD = :XCODCAD;
DELETE FROM PHCNAT  WHERE PHCNAT.CODEMP = :XCODEMP AND PHCNAT.CODCAD = :XCODCAD;
DELETE FROM PHCPIS  WHERE PHCPIS.CODEMP = :XCODEMP AND PHCPIS.CODCAD = :XCODCAD;
DELETE FROM PHCPRE  WHERE PHCPRE.CODEMP = :XCODEMP AND PHCPRE.CODCAD = :XCODCAD;
DELETE FROM PHCPRO  WHERE PHCPRO.CODEMP = :XCODEMP AND PHCPRO.CODCAD = :XCODCAD;
DELETE FROM PHCRES  WHERE PHCRES.CODEMP = :XCODEMP AND PHCRES.CODCAD = :XCODCAD;
DELETE FROM PHCSIN  WHERE PHCSIN.CODEMP = :XCODEMP AND PHCSIN.CODCAD = :XCODCAD;
DELETE FROM PHCGPS  WHERE PHCGPS.CODEMP = :XCODEMP AND PHCGPS.CODCAD = :XCODCAD;
DELETE FROM PHCVIN  WHERE PHCVIN.CODEMP = :XCODEMP AND PHCVIN.CODCAD = :XCODCAD;
end
 ^

SET TERM ; ^
COMMIT WORK;
SET AUTODDL ON;


